// $Id: CStringTokeniser.cpp,v 1.6 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CStringTokeniser.hpp"
using Exponent::Basics::CStringTokeniser;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CStringTokeniser, CCountedObject);

//	===========================================================================
CStringTokeniser::CStringTokeniser(const char *string) : m_numberOfTokens(0), m_numberOfTokensReturned(0), m_lastTokenPosition(0), m_token(',')
{
	EXPONENT_CLASS_CONSTRUCTION(CStringTokeniser);
	if (string)
	{
		this->setStringToTokenize(string);
		this->setTokenizationCharacter(',');
		m_numberOfTokens = 0;
		m_lastTokenPosition = 0;
	}
}

//	===========================================================================
CStringTokeniser::CStringTokeniser(const CString &string) : m_numberOfTokens(0), m_numberOfTokensReturned(0), m_lastTokenPosition(0), m_token(',')
{
	EXPONENT_CLASS_CONSTRUCTION(CStringTokeniser);
	this->setStringToTokenize(string.getString());
	this->setTokenizationCharacter(',');
	m_numberOfTokens = 0;
	m_lastTokenPosition = 0;
}

//	===========================================================================
CStringTokeniser::CStringTokeniser(const CString &string, const char token) : m_numberOfTokens(0), m_numberOfTokensReturned(0), m_lastTokenPosition(0), m_token(',')
{
	EXPONENT_CLASS_CONSTRUCTION(CStringTokeniser);
	this->setStringToTokenize(string.getString());
	this->setTokenizationCharacter(token);
	m_numberOfTokens = this->getNumberOfTokens();
	m_lastTokenPosition = 0;
}

//	===========================================================================
CStringTokeniser::CStringTokeniser(const char *string, const char token) : m_numberOfTokens(0), m_numberOfTokensReturned(0), m_lastTokenPosition(0), m_token(',')
{
	EXPONENT_CLASS_CONSTRUCTION(CStringTokeniser);
	if (string)
	{
		this->setStringToTokenize(string);
		this->setTokenizationCharacter(token);
		m_numberOfTokens = this->getNumberOfTokens();
		m_lastTokenPosition = 0;
	}
}

//	===========================================================================
CStringTokeniser::~CStringTokeniser()
{
	EXPONENT_CLASS_DESTRUCTION(CStringTokeniser);
	// Nothing dynamic...
}

//	===========================================================================
void CStringTokeniser::setTokenizationCharacter(const char token)
{
	m_token = token;
	m_numberOfTokensReturned = 0;
}

//	===========================================================================
void CStringTokeniser::setStringToTokenize(const char *string)
{
	if (string)
	{
		strcpy(m_string, string);
	}
	m_numberOfTokensReturned = 0;
}

//	===========================================================================
char *CStringTokeniser::getNextToken()
{
	// Check that we can actually do this
	if (!this->hasMoreTokens())
	{
		return NULL;
	}

	// Get the length of the string
	size_t lengthOfString = strlen(m_string);

	// have we found the delimiter
	bool foundDelimiter = false;

	// how many tokens do we have
	long tokenLength = 0;

	// First we need to work out how many characters there are in our token
	for (size_t i = m_lastTokenPosition; i < lengthOfString && !foundDelimiter; i++)
	{
		if (m_string[i] != m_token)
		{
			tokenLength++;
		}
		else
		{
			foundDelimiter = true;
		}
	}

	foundDelimiter = false;

	// The token that we are going to return
	char *tokenPtr = new char[tokenLength + 1];
	memset(tokenPtr, 0, (tokenLength + 1) * sizeof(char));
	long position = 0;
	for (size_t i = m_lastTokenPosition; i < lengthOfString && !foundDelimiter; i++)
	{
		if (m_string[i] != m_token)
		{
			tokenPtr[position++] = m_string[i];
		}
		else
		{
			foundDelimiter = true;
			m_lastTokenPosition = (long)(i) + 1;
		}
	}

	// increment to say that we have move onwards
	m_numberOfTokensReturned++;
	return tokenPtr;
}

//	===========================================================================
bool CStringTokeniser::getNextToken(CString &string)
{
	// Get the token
	char *token = this->getNextToken();

	// CHeck its valid
	if(token == NULL)
	{
		return false;
	}

	// Store it
	string = token;

	// Clear it
	FREE_ARRAY_POINTER(token);

	// Done!
	return true;
}

//	===========================================================================
bool CStringTokeniser::hasMoreTokens()
{
	return (m_numberOfTokensReturned != m_numberOfTokens);
}

//	===========================================================================
long CStringTokeniser::getNumberOfTokens()
{
	// Get the length of the string
	size_t lengthOfString = strlen(m_string);

	// The number of sections that we have
	long numberOfSections = 0;

	// was the last character encountered a delimiter
	bool lastWasDelimiter = false;
	if (m_string[0] != '_') lastWasDelimiter = true;

	// Loop through the string. If there is a delimiter, we have a new section
	for (size_t i = 0; i < lengthOfString; i++)
	{
		if (m_string[i] == m_token)
		{
			lastWasDelimiter = true;
		}
		else if (m_string[i] != m_token && lastWasDelimiter)
		{
			++numberOfSections;
			lastWasDelimiter = false;
		}
	}

	// Store the number
	m_numberOfTokens = numberOfSections;

	// Return the number that we found
	return numberOfSections;
}